function setUser()
{
	var username = document.getElementById(USERNAME_PREFERENCE_FIELD);
	setUsername(username.value);
	refreshFriendsList();
}

function getUsername()
{
	var username = widget.preferenceForKey(widget.identifier + CURRENT_USERNAME_KEY);
	if (!username)
	{
		username = getDefaultUsername();
	}
	
	return username;
}

function setUsername(username)
{
	widget.setPreferenceForKey(username, widget.identifier + CURRENT_USERNAME_KEY);
	setDefaultUsername(username);
}

function getTracksUsername()
{
	var username = widget.preferenceForKey(widget.identifier + TRACKS_USERNAME_KEY);
	if (!username)
	{
		username = getDefaultTracksUsername();
	}
	
	return username;
}

function setTracksUsername(username)
{
	widget.setPreferenceForKey(username, widget.identifier + TRACKS_USERNAME_KEY);
	setDefaultTracksUsername(username);
	refreshTrackList(true);
}

function getDefaultUsername()
{
	var username = widget.preferenceForKey(CURRENT_USERNAME_KEY);
	if (!username)
	{
		username = DEFAULT_USERNAME;
	}
	
	return username;
}

function setDefaultUsername(username)
{
	widget.setPreferenceForKey(username, CURRENT_USERNAME_KEY);
}

function getDefaultTracksUsername()
{
	var username = widget.preferenceForKey(TRACKS_USERNAME_KEY);
	if (!username)
	{
		username = DEFAULT_USERNAME;
	}
	
	return username;
}

function setDefaultTracksUsername(username)
{
	widget.setPreferenceForKey(username, TRACKS_USERNAME_KEY);
}

function changeFrontColour(colour)
{
	Dhtml.setClass("front", "front-" + colour);
}

function setFrontColour()
{
	var colourList = document.getElementById(FRONT_COLOUR_PREFERENCE_FIELD);
	var colour = colourList.value;
	widget.setPreferenceForKey(colour, widget.identifier + FRONT_COLOUR_KEY);
	widget.setPreferenceForKey(colour, FRONT_COLOUR_KEY);
	changeFrontColour(colour);
}

function getFrontColour()
{
	var colour = widget.preferenceForKey(widget.identifier + FRONT_COLOUR_KEY);
	if (!colour)
	{
		colour = widget.preferenceForKey(FRONT_COLOUR_KEY);
		if (!colour)
		{
			colour = DEFAULT_FRONT_COLOUR;
		}
	}
	return colour;
}

function setVersionCheck()
{
	var versionCheck = document.getElementById(VERSION_CHECK_PREFERENCE_FIELD);
	var versionCheckEnabled = versionCheck.checked;
	debug("Set version checking enabled - " + versionCheckEnabled);
	widget.setPreferenceForKey(versionCheckEnabled, VERSION_CHECK_KEY);
	if (versionCheckEnabled)
	{
		doVersionCheck();
	}
	else
	{
		Dhtml.hideElement(NEW_VERSION_AVAILABLE_FIELD);
	}
}

function versionCheckEnabled()
{
	var versionCheckEnabled = widget.preferenceForKey(VERSION_CHECK_KEY);
	if (typeof(versionCheckEnabled) == "undefined")
	{
		versionCheckEnabled = DEFAULT_VERSION_CHECK_ENABLED;
	}
	debug("Version checking enabled - " + versionCheckEnabled);
	return versionCheckEnabled;
}